package gov.va.genisis2.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
* The Class FieldToolTipDescription.
* 
* Description: In this FieldToolTipDescription Class implements the interface Serializable
* and defines the entity and data mapping for the dbo.Field_ToolTip_Description Table in
* the database.
*/

@Entity
@Table(name = "Field_ToolTip_Description", schema = "dbo", uniqueConstraints = @UniqueConstraint(columnNames = "FieldName"))
public class FieldToolTipDescription implements java.io.Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7072536626613989587L;
	
	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The fieldName. */
	@Column(name = "FieldName", unique = true, nullable = false, length = 50)
	private String fieldName;
	
	/** The textDescription. */
	@Column(name = "TextDescription", nullable = false, length = 4000)
	private String textDescription;

	public FieldToolTipDescription() {
	}

/*	public FieldToolTipDescription(int id, String fieldName, String textDescription) {
		this.id = id;
		this.fieldName = fieldName;
		this.textDescription = textDescription;
	}
*/
	
	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@Column(name = "FieldName", unique = true, nullable = false, length = 50)
	public String getFieldName() {
		return this.fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	
	public String getTextDescription() {
		return this.textDescription;
	}

	public void setTextDescription(String textDescription) {
		this.textDescription = textDescription;
	}
}